<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la conexi0560n desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permite la ejecuci0560n de los m0106todos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8"); // Asegurarse de que este encabezado se env06e antes de cualquier salida

// Se incluye el archivo que contiene la clase gen0106rica
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

$rows = array();
$sql = "Call Listar_Usua_Excel(?,?)";

// Preparar la sentencia
if ($stmt = mysqli_prepare($conn, $sql)) {
    // Vincular par0700metros
    mysqli_stmt_bind_param($stmt, "is", $datos[0],$datos[1]);

    // Ejecutar la sentencia
    if (mysqli_stmt_execute($stmt)) {
        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $rows[] = $row;
            }
            mysqli_free_result($result); // Liberar el resultado
        } else {
            // No se encontraron registros
            $rows = [];
        }
    } else {
        error_response("Error al ejecutar la consulta.");
    }
    mysqli_stmt_close($stmt); // Cerrar la sentencia
} else {
    error_response("Error al preparar la consulta.");
}

// Cerrar la conexi0560n a la base de datos
mysqli_close($conn);

// Imprimir la respuesta en formato JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>