<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación de parámetros
    if (!isset($datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5])) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    // Llamada al procedimiento almacenado (sin retorno explícito)
    $sql = "SELECT * FROM activa_opcion(:menu_id, :submenu_id, :usuario_id, :opcion_id, :activo, :nombre_opcion)";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':menu_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':submenu_id', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':usuario_id', $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':opcion_id', $datos[3], PDO::PARAM_INT);
    $stmt->bindValue(':activo', filter_var($datos[4], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':nombre_opcion', $datos[5], PDO::PARAM_STR);

    $stmt->execute();

    // Retorno personalizado
    $resultado = [
        "ESTADO" => "1",
        "MENSAJE" => "La información se actualizó correctamente"
    ];

} catch (PDOException $e) {
    $resultado = [
        "ESTADO" => "0",
        "MENSAJE" => "Error al ejecutar el procedimiento: " . $e->getMessage()
    ];
} catch (Exception $e) {
    $resultado = [
        "ESTADO" => "0",
        "MENSAJE" => "Error general: " . $e->getMessage()
    ];
} finally {
    $conn = null;
}

echo json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
