<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar parámetros
if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
    error_response("Parámetros insuficientes.");
}

$param1 = $datos[0];
$param2 = $datos[1];
$param3 = $datos[2];
$param4 = $datos[3];

try {
    $sql = "SELECT * FROM Buscar_Producto_General(:param1, :param2, :param3, :param4)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":param1", $param1, PDO::PARAM_INT);
    $stmt->bindParam(":param2", $param2, PDO::PARAM_INT);
    $stmt->bindParam(":param3", $param3, PDO::PARAM_STR);
    $stmt->bindParam(":param4", $param4, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        success_response("No se encontraron productos.", []);
    } else {
        success_response("Productos encontrados.", $rows);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => "Error DB: " . $e->getMessage(), // TEMPORALMENTE muestra el error
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}

// ✅ Enviar respuesta exitosa
function success_response($mensaje, $data = []) {
    echo json_encode([
        "estado" => "00",
        "mensaje" => $mensaje,
        "data" => $data
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

// ❌ Enviar error con formato uniforme
function error_response($mensaje) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => $mensaje,
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
