<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer y decodificar JSON
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        error_response("Parámetros insuficientes. Se requieren 3 valores.");
    }

    $param1 = $datos[0];
    $param2 = $datos[1];
    $param3 = $datos[2];

    // Preparar y ejecutar procedimiento almacenado con PDO
    $sql = "SELECT * FROM Buscar_ProdCompra(:param1, :param2, :param3)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':param1', $param1, PDO::PARAM_INT);
    $stmt->bindParam(':param2', $param2, PDO::PARAM_STR);
    $stmt->bindParam(':param3', $param3, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        success_response("No se encontraron productos.", []);
    } else {
        success_response("Productos encontrados.", $rows);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => "Error de base de datos: " . $e->getMessage(),
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}

// Función para respuesta exitosa
function success_response($mensaje, $data = []) {
    echo json_encode([
        "estado" => "00",
        "mensaje" => $mensaje,
        "data" => $data
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

// Función para error general
function error_response($mensaje) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => $mensaje,
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
