<?php
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $body = json_decode(file_get_contents("php://input"), true);

    if (!isset($body['docfiscal_id'], $body['sucursal_id'], $body['usuario_id'])) {
        throw new Exception("Faltan parámetros.");
    }

    $docfiscal_id = $body['docfiscal_id'];
    $sucursal_id = $body['sucursal_id'];
    $usuario_id = $body['usuario_id'];

    $stmt = $conn->prepare("SELECT obtener_serie_recibos(:docfiscal_id, :sucursal_id, :usuario_id)");
    $stmt->bindParam(':docfiscal_id', $docfiscal_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();

    echo $stmt->fetchColumn(); // ya devuelve un JSON completo
} catch (Exception $e) {
    echo json_encode([
        'ESTADO' => '0',
        'MENSAJE' => 'Error: ' . $e->getMessage()
    ]);
}
