<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar entrada
if (!isset($datos[0], $datos[1])) {
    error_response("Parámetros insuficientes.");
}

$empresa_id = $datos[0];
$producto_id = $datos[1];

try {
    $sql = "SELECT id, nombre, capacidad_precio, abrev_precio, abrev_universal, precio_venta 
            FROM equivalencias 
            WHERE empresa_id = :empresa_id 
              AND producto_id = :producto_id 
            ORDER BY capacidad_precio DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindValue(':producto_id', $producto_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        error_log("⚠️ No se encontraron equivalencias para el producto $producto_id.");
        success_response("No se encontraron equivalencias.", []);
    }

    success_response("Equivalencias encontradas.", $rows);

} catch (PDOException $e) {
    error_response("Error DB: " . $e->getMessage());
} finally {
    $conn = null; // Cerrar conexión
}

// ✅ Funciones de respuesta
function success_response($mensaje, $data) {
    echo json_encode([
        'estado' => '00',
        'mensaje' => $mensaje,
        'data' => $data
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

function error_response($mensaje) {
    http_response_code(500);
    echo json_encode([
        'estado' => '99',
        'mensaje' => $mensaje,
        'data' => []
    ], JSON_UNESCAPED_UNICODE);
    exit();
}
