<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
//include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
//$usuarioId = TokenValidator::validar($conn);

$respuesta = []; // Siempre se define, evita que se devuelva [] inesperadamente

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0]) || !isset($datos[1]) || !isset($datos[2])) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $fecha  = $datos[0];
    $compra = $datos[1];
    $venta  = $datos[2];

    $sql = "SELECT im_tipocambio(:fecha, :compra, :venta) AS registros";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':fecha',  $fecha,  PDO::PARAM_STR);
    $stmt->bindValue(':compra', $compra, PDO::PARAM_STR);
    $stmt->bindValue(':venta',  $venta,  PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result && isset($result['registros'])) {
        $nRegistros = $result['registros'];

        if ($nRegistros > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "REGISTROS" => $nRegistros,
                "MENSAJE" => "La información se registró correctamente"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "REGISTROS" => "0",
                "MENSAJE" => "No se registró ningún dato"
            ];
        }
    } else {
        throw new Exception("No se pudo obtener resultado desde la función im_tipocambio.");
    }

} catch (Exception $e) {
    $respuesta = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ];
} finally {
    $conn = null;
    echo json_encode($respuesta, JSON_PRETTY_PRINT);
}
?>
